/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	pgpMiscNT.c	- miscellaneous NT-specific functions for PGP Utility Driver
	

	$Id: pgpMisc9x.c,v 1.5 2001/03/12 21:23:37 pbj Exp $
____________________________________________________________________________*/

#define WANTVXDWRAPS
#include <basedef.h>
#include <vmm.h>
#include <vtd.h>
#include <vwin32.h>
#include <vxdwraps.h>

#ifndef PGP_EROS
#define PGP_EROS	0
#endif // PGP_EROS

#include "pgpMisc.h"

// typedefs
typedef struct {
	PVMMMUTEX	mutex;
} pgpDriverCriticalSection;


//	______________________________________________________
//
//  memory allocation

PVOID
pgpDriverSecureAlloc (
		ULONG	ulNumBytes)
{
	return (_HeapAllocate (ulNumBytes, HEAPZEROINIT|HEAPLOCKEDIFDP));
}

VOID
pgpDriverSecureFree (
		PVOID p)
{
	if (p)
		_HeapFree (p, 0);
}


//	______________________________________________________
//
//  critical section handlers

VOID
pgpDriverEnterCriticalSection (
		pgpDriverCriticalSection*	pSection,
		ULONG						ulType)
{
	// SPINLOCK critical section is a NOP
	if (ulType == MUTEX)
		_EnterMutex (pSection->mutex, BLOCK_THREAD_IDLE|BLOCK_SVC_INTS);
}

ULONG
pgpDriverTryToEnterCriticalSection (
		pgpDriverCriticalSection*	pSection,
		ULONG						ulType)
{
	// SPINLOCK critical section is a NOP
	if (ulType == MUTEX)
	{
		if (_GetMutexOwner (pSection->mutex) == 0)
		{
			_EnterMutex (pSection->mutex, BLOCK_THREAD_IDLE|BLOCK_SVC_INTS);
			return TRUE;
		}
		else
			return FALSE;
	}
	else
		return TRUE;
}

VOID
pgpDriverLeaveCriticalSection (
		pgpDriverCriticalSection*	pSection,
		ULONG						ulType)
{
	// SPINLOCK critical section is a NOP
	if (ulType == MUTEX)
		_LeaveMutex (pSection->mutex);
}


VOID
pgpDriverInitCriticalSection (
		pgpDriverCriticalSection*	pSection)
{
	pSection->mutex = _CreateMutex (0, MUTEX_MUST_COMPLETE);
}

VOID
pgpDriverCleanupCriticalSection (
		pgpDriverCriticalSection*	pSection)
{
	_DestroyMutex (pSection->mutex);
	pSection->mutex = 0;
}


//	______________________________________________________
//
//  miscellaneous

void
pgpCopyMemory(void *src, void *dst, int size)
{
	memcpy(dst, src, size);
}


#if !PGP_EROS
//	______________________________________________________
//
//  high resolution timing

/*
 * Add as much timing-dependent random noise as possible
 * to the randPool.  Typically, this involves reading the most
 * accurate system clocks available.
 *
 * Returns the number of ticks that have passed since the last call,
 * for entropy estimation purposes.
 *
 * Structured Exception Handling is not supported in the VMM
 * so there is no safe way to test for the presence of the 
 * Pentium Time Stamp Counter (TSC) (as we do in the NT/2000
 * driver).  Thus, we just use the VTD_Get_Real_Time function 
 * which has a resolution of 0.8 microseconds.
 */

VOID
pgpDriverGetHiResTime (
		PULONG	pulLowPart)
{
	__int64	liTime;

	liTime = VTD_Get_Real_Time ();

	*pulLowPart = (ULONG)(liTime & 0xFFFFFFFF);
}
#endif // !PGP_EROS
